


markup.push({

// MARK: - EQ block

ParametricEQBlock:
{
	"+": "BlockTemplate",
	gxPopoverInfo: "ParametricEQPopover",
	gxFaceModel: {
		nsClass: "H4ParamEqBlockFace",
		gxFaceModelKeyPath: "faceModel",
	},
	gxTitle: "Parametric EQ",
	gxLibraryDescription: "Fine-tune specific frequencies",
	gxDescriptionKeyPath: "faceModel.blockDescription",
	geNodeClass: "AHNBandEQNode",
	h4PresetsId: "ParametricEQPresets",
	gxLibraryIcon: "library.effect.parametricEq",
	gxChildViews:
	{
		sparkline:
		{
			nsClass: "GXDrawView",
			gxValueKey: "sparklineData",
			gxFrameRect: "14,36,92,43",
			gxForePainter: {
				nsClass: "GXSparklinePainter",
				gxStrokeColor: "ForeColorTheme1",
				gxEdgeInsets: "3, 3, 3, 3",	// leave space for points
				gxRangeMin: -14,
				gxRangeMax: 14,
				gxStrokeWidth: 2.5,
			}
		},
		presets:
		{
			"+": "BlockPopup.stripMarkup",
			gxFaceModel: {
				nsClass: "H4PresetsFaceModel",
			},
			gxShowOnKey: "hasPresets",
			gxMenuItemsKeyPath: "corePresetsMenuItems",
			axTitle: "Presets",
			axHelp: "Create or use pre-sets for this block",
		},
	},
},

	
// MARK: - EQ popover
    
ParametricEQPopover:
{
	"+": "PopoverTemplate",
	gxTitle: "Parametric Equalizer", 
	gxLayout: [
		"H:|-12-[self]-12-|",
		"V:|-12-[self]-12-|",

		"V:|-41-[divider]-0-[curveHost(290)]-0-[bandButtons]-0-[bandSettingsBtn]-0-[bandSettingsGroup]-8-[presetsGroup]",
		
		"V:[divider]-19-[divider12]-62-[divider6]-62-[divider0]-61-[dividerminus6]-62-[dividerminus12]",
		
		"H:|-0-[curveHost(576)]-0-|",
		
		"H:|-0-[bandButtons]-0-|",
		//"H:|-0-[bandGroup]-0-|",
	],
	gxCanDrawSubviewsIntoLayer: true,
	gxWantsLayer: true,
	gxChildViews:
	{
		title: "PopoverTitle",
		switch: "PopoverOnOffSwitch",
		presetsGroup: presetsGroup(),
			
		divider: dividerView(),
		divider12: dbStripe(),
		divider6: dbStripe(),
		divider0: dbStripe(),
		dividerminus6: dbStripe(),
		dividerminus12: dbStripe(),
			
		curveHost: { "+": "CurveHost" },
		bandButtons: {"+": "ParamBandButtons" },
		bandSettingsBtn: {
			"+": "AdvancedGroupButton",
			gxTitle: "<disclosure/> Selected Band",
			axFormatter: disclosureAxFormatter("Selected Band"),
			gxValueKey: "uiState.bandSettingsExpanded"
		},
		bandSettingsGroup: { "+": "BandSettingsGroup" },
	}
}, 
 
	
// MARK: - EQ plot

CurveHost:
{
	nsClass: "GXLayerHostingView",
	gxLayerZPosition: 11,
	gxDenyHitTest: 0,	// don't deny
	gxCanMoveWindow: false,
	axIsIgnored: false,
	axTitleKeyPath: "faceModel.axDescription",
	axHelp: "Bands may be selected using the number keys. Left right keys then adjust frequency. Up down keys adjust gain, Option up down adjusts Q factor",
	gxDragger : { nsClass: "H4EqNewBandDragger" },		// a dragger that makes new bands on double click
	gxLayout: [
		"H:|-0-[selectedShape]-0-|",
		"V:|-0-[selectedShape]-0-|",
	],
	gxRootLayer:
	{
		nsClass: "GXShapeLayer",
		gxViewName: "magnitudeShape",
		gxListItemsKeyPath: "bandModels",
		gxListItemView: BandShape(),
		gxLayerZPosition: 2,
		gxLineJoinRound: true,
		gxPainter: {    // for colors only
			nsClass: "GXPainter",
			gxStrokeWidth: 3.0,
			gxFrameColor: "ForeColor1",
		},
		gxSublayers:
		{
			selectedShape: {
				nsClass: "GXShapeLayer",
				gxLayerZPosition: 3,
				//gxModelKeyPath: "selectedFaceModel",
				gxValueKey: "selectedBand.bandPathValue",
				gxDisableOnKey: "selectedBand.bandDisabled",
				gxLineJoinRound: true,
				// this selected shape includes a larger circle, matching the larger size caused by stroke on the 'real' band's indicator.
				// we add a dragger and wheeler to this so it can be clicked more easily.
				gxDragger : { nsClass: "H4EqBandDragger" },
				gxWheeler: { nsClass: "H4EqBandWheeler" },
				gxPainter: {    // for colors only
					nsClass: "GXPainter",
					gxStrokeWidth: 1.0,
					disabled: {
						gxStrokeWidth: 0.75,
						gxFrameColor: "ForeColor2.noDisabled",
					},
					gxFrameColor: "ColorThemeLive1",
				},
			},
		},
	},
},

	
ParamBandButtons:
{
	nsClass: "GXDrawView",
	gxBackPainter: "GroupViewBack.noBottomStroke",
	gxLayout: [
		"V:|-10-[stackView(36)]-8-[addBtn]-8-|",

		"H:|-12-[stackView(100)]",
		"H:|-12-[addBtn(100)]-(>=16)-[deleteBtn(104)]-10-|&alignBaseline",
	],
	gxChildViews:
	{
		stackView:
		{
			nsClass: "GXStackView",
			gxHorizontal: true,
			gxInterItemHeight: 4,
			gxExpandedSize: 575,
			gxDefaultValue: true,	// expanded
			gxListItemsKeyPath: "bandModels",
			gxListItemView: BandButton(),
		},
		addBtn: {
			"+" : "PlusButton",
			gxTitle: "<plusButton/> Add Band",
			axHelp: "Add an Equalizer band, up to a maximum of 10",
		},
		deleteBtn: {
			"+" : "MinusButton",
			gxTitle: "<minusButton/> Delete Band",
			axHelp: "Delete the selected Equalizer band",
		},
	},
},
	
// MARK: - single band group

BandSettingsGroup:
{
	"+": "ExpandingGroupView.noTopStroke",
	gxValueKey: "uiState.bandSettingsExpanded",
	gxCollapsible: true,
	gxCollapsedSize: 1,
	gxExtraSize: 16,
	//axHelp: "Contains mixer settings for one input to this block",
	gxLayout:
	[
		"H:|-0-[self]-0-|",

		"V:|-4-[bandType]-14-[gainSlider]-12-[frequencySlider]&alignLeft",

		"H:[typeLabel]-8-[bandType(130)]-16-[qLabel(20)]-8-[qSlider]-0-[qReadout(31)]-16-[enabledSwitch(52)]-16-|&alignBaseline",
		"H:[gainLabel(76)]-7-[gainSlider]-0-[gainReadout(56)]-16-|&alignBaseline",
		"H:|-12-[frequencyLabel(76)]-7-[frequencySlider]-0-[frequencyReadout(56)]-16-|&alignBaseline",
	],
	gxChildViews:
	{
		enabledSwitch: {
			"+": "SwitchView.showLive",
			gxValueKey: "selectedBand.enabled",
			gxBaselineOffset: 6,
			axTitle: "Band Enabled",
			axHelp: "When off, this band does not apply equalization",
		},
		typeLabel: labelView("Type:"),
		bandType: {
			"+": "PopupMenuTemplate.useMarkup",
			gxValueKey: "selectedBand.bandType",
			gxMenuItems: "BandTypeMenuItems",
			axIsIgnored: false,
			axTitle: "Band type",
			axHelp: "The filter type of the currently selected band",
		},
		frequencyLabel: labelView("Frequency:"),
		frequencySlider:
		{
			"+": "SliderView",
			gxDefaultValue: 0.1,
			gxValueKey: "selectedBand.logFrequency",
			axTitle: "Frequency",
			axHelp: "The center frequency of the currently selected band",
			axValueKeyPath: "selectedBand.frequency",
			axFormatter: "HertzFormatter"
		},
		frequencyReadout:
		{
			"+":  "ReadoutView.right",
			gxValueKey: "selectedBand.frequency",
			gxFormatter: "HertzFormatter",
		},
		gainLabel: labelView("Gain:"),
		gainSlider:
		{
			"+": "SliderView",
			gxValueKey: "selectedBand.gain",
			gxDisableOnKey: "selectedBand.isPassFilter",
			gxDefaultValue: 0,
			gxDetents: "0",
			gxRangeMin: -12,
			gxRangeMax: 12,
			axTitle: "Gain",
			axHelp: "The gain of the currently selected band",
			axFormatter: "DBFormatter"
		},
		gainReadout:
		{
			"+": "ReadoutView.right",
			gxValueKey: "selectedBand.gain",
			gxFormatter: "DBFormatter",
		},
		qLabel: labelView("Q:"),
		qSlider:
		{
			"+": "SliderView",
			gxValueKey: "selectedBand.logQValue",
			gxDefaultValue: 1,
			gxRangeMin: 0,
			gxRangeMax: 1,
			axTitle: "Q",
			axHelp: "The Q factor of the currently selected band",
			axValueKeyPath: "selectedBand.qValue",
			axFormatter:  { nsClass: "GXScaledFormatter", format: "% .1f" }
		},
		qReadout:
		{
			"+": "ReadoutView.right",
			gxValueKey: "selectedBand.qValue",
			gxFormatter: { nsClass: "GXScaledFormatter", format: "% .1f" }
		},
	}
},
	
	
// MARK: band type items
	
BandTypeMenuItems: [
	menuItem("<menuIcon.foreColor1.peq-hp/> High Pass", 0, "useMarkup"),
	menuItem("<menuIcon.foreColor1.peq-ls/> Low Shelf", 1, "useMarkup"),
	menuItem("<menuIcon.foreColor1.peq-pk/> Peaking", 2, "useMarkup"),
	menuItem("<menuIcon.foreColor1.peq-hs/> High Shelf", 3, "useMarkup"),
	menuItem("<menuIcon.foreColor1.peq-lp/> Low pass", 4, "useMarkup"),
],


})


// MARK: - functions


function BandButton()
{
	return {
		"+" : "TabButtonView.centerx.useMarkup.size10",
		nsClass: "GXListItemView",
		gxSelectable: 1,  // single select
		gxViewName: "bandBtn",
		gxDisplayValueKey: "bandBtnTitle",
		axIsIgnored: false,
		axRoleDescription: "Band",
		axValueKeyPath: "bandDescription",
		//axTitleKeyPath: "bandDescription",
		//axDescriptionKeyPath: "bandDescription",
		gxLateLayout: [
			"H:|-600-[self(46)]",		// left position here is adjust by enclosing list
			"V:[self(35)]"
		],
	};
}

function BandShape()
{
	return {
		nsClass: "GXShapeLayer",
		gxValueKey: "bandPointPathValue",
		gxDisableOnKey: "bandDisabled",
		gxLineJoinRound: true,
		gxMenuItemsKeyPath: "contextMenuItems",
		gxDragger : { nsClass: "H4EqBandDragger" },
		gxWheeler: { nsClass: "H4EqBandWheeler" },
		gxPainter: {    // for settings only, not the path
			nsClass: "GXPainter",
			gxStrokeWidth: 1.0,
			selected: {
				gxFillColor: "WhiteColor.noDisabled",
				gxStrokeWidth: 4.0,
				gxFrameColor: "ColorThemeLive1",
				disabled: {
					//gxStrokeWidth: 0.5,
					//gxFillColor: "ColorTheme2.blockDisabled",
					gxFrameColor: "ForeColor2.noDisabled",
				},
			},
			disabled: {
				//gxStrokeWidth: 0.5,
				gxFillColor: "ForeColor2.noDisabled",
				gxFrameColor: "ForeColor2.noDisabled",
			},
			gxFillColor: "ColorThemeLive1",
			//gxFrameColor: "ColorTheme2",
		},
	};
}

function dbStripe()
{
	return {
		nsClass: "GXDrawView",
		gxLayout:
		[
			"V:[self(1)]",
			"H:|-0-[self]-0-|",
		],
		gxBackPainter: fillPainter("BackColor3.disabled"),
	};
}


